<?php
/**
* Dispatcher
* Permet de charger le controller en fonction de la requte utilisateur
**/
class Dispatcher{
	var $request;
	// Object Request
	/**
	* Fonction principale du dispatcher
	* Charge le controller en fonction du routing
	**/
	function __construct() {
		// pour debugger le droulemnt des appels de modules
//echo "Session active est ".session_id()." - Module Dispatcher(construct)  at ".microtime(true).' sec'."<br/>"; 

		$this->request = new Request(); 
		Router::parse($this->request->url,$this->request); 
		$controller = $this->loadController();
		$action = $this->request->action;
		if($this->request->prefix){
			$action = $this->request->prefix.'_'.$action;
		}
		if(!in_array($action , array_diff(get_class_methods($controller),get_class_methods('Controller'))) ){
			$this->error('Le controller '.$this->request->controller.' n\'a pas de mthode '.$action); 
		}
		call_user_func_array(array($controller,$action),$this->request->params); 
		$controller->render($action);

	}

	/**
	* Permet de gnrer une page d'erreur en cas de problme au niveau du routing (page inexistante)
	**/
	function error($message){
		$controller = new Controller($this->request);
		//$controller->suiviConnexions();
		$controller->e404($message); 
	}

	/**
	* Permet de charger le controller en fonction de la requte utilisateur
	**/
	function loadController() {
		// pour debugger le droulemnt des appels de modules
//echo "Session active est ".session_id()." - Module Dispatcher(loadController)  at ".microtime(true).' sec'."<br/>"; 

		if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
            strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {$this->request->controller ='ajax';}
        //  echo 'type requete '.  $_SERVER['HTTP_X_REQUESTED_WITH'].'</br>';
         //echo ' on est dans loadController - on load le controller'.$this->request->controller.'</br>';
		//var_dump ($request); echo '</br>';   

		$name = ucfirst($this->request->controller).'Controller'; 
		$file = ROOT.DS.'controller'.DS.$name.'.php';
				if(!file_exists($file)){
			$this->error('Le controller '.$this->request->controller.' n\'existe pas'); 
		} 

		require $file; 
		$controller = new $name($this->request); 
		
		return $controller;  
	}


}