<?php
class Form{
	
	public $controller; 
	public $errors; 

	public function __construct($controller){
		$this->controller = $controller; 
			// pour debugger le droulemnt des appels de modules
			//echo "Session active est ".session_id()." - Module Form(construct)  at ".microtime(true).' sec'."<br/>"; 

	}
/*
* Gnre un formulaire vertical
* les erreurs dtectes sont affiches en dessous de la zone en erreur
*/
	public function input($name,$label,$options = array()){
		$error = false; 
		$errors=array();
		$classError = ''; 
		if(isset($this->errors[$name])){
			$error = $this->errors[$name];
			$classError = ' error'; 
		}
		if(!isset($this->controller->request->data->$name)){
			$value = ''; 
		}else{
			$value = $this->controller->request->data->$name; 
		}
			
		if($label == 'hidden'){
			return '<input type="hidden" name="'.$name.'" value="'.$value.'"/>'; 
		}
		$html = "<tr><td width='30%' align='left' class='".$classError."'>
					<label for='input".$name."'>".$label."</label></td><td>";
		$attr = ' '; 
		foreach($options as $k=>$v){ if($k!='type'){
			$attr .= " $k=\"$v\""; 
			if ($value ==='' && isset($options['value'])) {$value= $v;}

		}}
		if(!isset($options['type']) && !isset($options['options'])){
			$html .= '<input type="text" id="input'.$name.'" name="'.$name.'" value="'.$value.'"'.$attr.'/>';
			
		}elseif(isset($options['options'])){

			$html .= '<select id="input'.$name.'" name="'.$name.'">';
			foreach($options['options'] as $k=>$v){
				$html .= '<option value="'.$v.'" '.($k==$value?'selected':'').'>'.$v.'</option>'; 
			}
			$html .= '</select>'; 
		}elseif($options['type'] == 'textarea'){
			$html .= '<textarea id="input'.$name.'" name="'.$name.'"'.$attr.'>'.$value.'</textarea>';
		}elseif($options['type'] == 'checkbox'){
			$html .= '<input type="hidden" name="'.$name.'" value="0"><input type="checkbox" name="'.$name.'" value="1" '.(empty($value)?'':'checked').'/>'; 
		}elseif($options['type'] == 'file'){
			$html .= '<input type="file" class="input-file" id="input'.$name.'" name="'.$name.'"'.$attr.'/>';
		}elseif($options['type'] == 'password'){
			$html .= '<input type="password" id="input'.$name.'" name="'.$name.'" value="'.$value.'"'.$attr.'/>';
		}
		if($error){
			$html .= '</td></tr><tr><td colspan=2 class="alert-error">'.$error;
		}
		$html .= '</td></tr>';
		return $html; 
	}

/*
* Gnre un formulaire horizontal
* les erreurs dtectes sont affiches en dessous du tableau dans une ou plusieurs lignes
*/

	public function input_tab($name,$label,$options = array()){
		$error = false; 
		$errors=array();
		$classError = ''; 
		if(isset($this->errors[$name])){
			$error = $this->errors[$name];
			$classError = ' error'; 
		}
		if(!isset($this->controller->request->data->$name)){
			$value = ''; 
		}else{
			$value = $this->controller->request->data->$name; 
		}
			
		if($label == 'hidden'){
			return '<input type="hidden" name="'.$name.'" value="'.$value.'"/>'; 
		}
		$html = //"<tr><td width='30%' align='left' class='".$classError."'>
					"<label for='input".$name."'>".$label."</label></td><td>";
		$attr = ' '; 
		foreach($options as $k=>$v){ if($k!='type'){
			$attr .= " $k=\"$v\""; 
			if ($value ==='' && isset($options['value'])) {$value= $v;}

		}}
		if(!isset($options['type']) && !isset($options['options'])){
			$html .= '<input type="text" id="input'.$name.'" name="'.$name.'" value="'.$value.'"'.$attr.'/>';
			
		}elseif(isset($options['options'])){

			$html .= '<select id="input'.$name.'" name="'.$name.'">';
			foreach($options['options'] as $k=>$v){
				$html .= '<option value="'.$v.'" '.($k==$value?'selected':'').'>'.$v.'</option>'; 
			}
			$html .= '</select>'; 
		}elseif($options['type'] == 'textarea'){
			$html .= '<textarea id="input'.$name.'" name="'.$name.'"'.$attr.'>'.$value.'</textarea>';
		}elseif($options['type'] == 'checkbox'){
			$html .= '<input type="hidden" name="'.$name.'" value="0"><input type="checkbox" name="'.$name.'" value="1" '.(empty($value)?'':'checked').'/>'; 
		}elseif($options['type'] == 'file'){
			$html .= '<input type="file" class="input-file" id="input'.$name.'" name="'.$name.'"'.$attr.'/>';
		}elseif($options['type'] == 'password'){
			$html .= '<input type="password" id="input'.$name.'" name="'.$name.'" value="'.$value.'"'.$attr.'/>';
		}
		if($error){
			$html .= '</td></tr><tr><td colspan=2 class="alert-error">'.$error;
		}
		$html .= '</td></tr>';
		return $html; 
	}
}