<?php 
/**
* Controller
**/
class Controller {
	public $request;  				// Objet Request 
	private $vars     = array();	// Variables  passer  la vue
	public $layout    = 'default';  // Layout  utiliser pour rendre la vue
	private $rendered = false;		// Si le rendu a t fait ou pas ?
	public $isLayout  = false;
//	public $table;

	/**
	* Constructeur
	* @param $request Objet request de notre application
	**/
	function __construct($request = null)
	{
		// pour debugger le droulemnt des appels de modules
		//echo "Session active est ".session_id()." - Module controller(construct) at ".microtime(true).' sec'."<br/>"; 

		$this->Session = new Session(); 
		$this->Form = new Form($this); 
		if($request){
			$this->request = $request; 	// On stocke le contenu de request dans l'instance	
			require ROOT.DS.'config'.DS.'hook.php'; 
		}
		$this->Session->write('s_affiche',false); 


	

//echo ' on est au dbut - on construit la classe controller';
//var_dump ($request); echo '</br>';
	}

	/**
	* Permet de rendre une vue
	* @param $view Fichier  rendre (chemin depuis view ou nom de la vue) 
	**/
	public function render($view) {
		$this->Session->write('s_vue',$view);
		//if($this->rendered){ return false; }
		if ($this->Session->read('s_affiche') == true) { return false; }
		// pour debugger le droulemnt des appels de modules
//echo "Session active est ".session_id()." - Module controller(render (".$view.")) at ".microtime(true).' sec'."<br/>"; 

		extract($this->vars); 
		if(strpos($view,'/')===0){
			$view = ROOT.DS.'view'.DS.$view.'.php';
		}
		else{
			$view = ROOT.DS.'view'.DS.$this->request->controller.DS.$view.'.php';
		}
		// // suivi des connexions
		// $this->suiviConnexions();
		
		ob_start(); 
		require($view);
		$content_for_layout = ob_get_clean(); 

		// on verifie si on est dans une requete de lien utilisant Ajax - on ne raffiche pas le layout gnral
		if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
			$this->layout = 'popup';
			echo $content_for_layout;
			echo $content_for_popup;
		}
		else {
			require ROOT.DS.'view'.DS.'layout'.DS.$this->layout.'.php'; 
		}		
		$this->Session->write('s_affiche',true); 
		//$this->rendered = true; 
//$suivi = debug_backtrace();
//echo $suivi."<br/>"; debug($_SESSION);
	}
	/**
	* Permet de rendre une vue demande en Ajax
	* @param $view Fichier  rendre (chemin depuis view ou nom de la vue) 
	**/
	public function ajaxRender($view) {
       // if ($this->Session->read('s_affiche') == true) { return false; }
        //$this->layout = 'popup';
       // extract($this->vars);
        $view = ROOT.DS.'view'.DS.$view.'.php';
       // ob_start(); 
        require($view);
		//$content_for_popup = ob_get_clean();
        $this->rendered = true;
    }

	/**
	* Permet de passer une ou plusieurs variables  la vue
	* @param $key nom de la variable OU tableau de variables
	* @param $value Valeur de la variable
	**/
	public function set($key,$value=null) {
		if(is_array($key)){
			$this->vars += $key; 
		}else{
			$this->vars[$key] = $value; 
		}
	}

	/**
	* Permet de charger un model
	**/
	function loadModel($name) {
		if(!isset($this->$name)){
			$file = ROOT.DS.'model'.DS.$name.'.php'; 
			require_once($file);
			$this->$name = new $name();
			if(isset($this->Form)){
				$this->$name->Form = $this->Form;  
			}
		}

	}

	/**
	* Permet de grer les erreurs 404
	**/
	function e404($message) {	
		header("HTTP/1.0 404 Not Found");
		$this->Session->write('s_vue','e404');
		$this->set('message',$message); 
		$this->layout = 'erreur';
		$this->render('/errors/404');
		die();
	}

	/**
	* Permet de grer les erreurs SQL
	**/
	function erreurSQL($message) {	
		header("HTTP/1.0 404 Not Found");
		$this->Session->write('s_vue','eSQL');
		$this->set('message',$message); 
		$this->layout = 'erreur';
		$this->render('/errors/SQL');
		die();
	}
	/**
	* Permet d'appeller un controller depuis une vue
	**/
	function request($controller,$action) {
		$controller .= 'Controller';
		require_once ROOT.DS.'controller'.DS.$controller.'.php';
		$c = new $controller();
		return $c->$action(); 
	}


	/**
	* Redirect
	**/
	public function redirect($url,$code = null ) {

		// suivi des connexions
		//$this->suiviConnexions();
		
		if($code == 301){
			header("HTTP/1.1 301 Moved Permanently");
		}
		if($code == 404){
			header("HTTP/1.1 404 Not Found");
		}
		//$_SERVER['HTTP_X_REQUESTED_WITH'] = 'xmlhttprequest';
		header("Location: ".Router::url($url));
	}


	// function suiviConnexions() {
		// $this->loadModel('Suivis');
		// $this->Suivis->table = 'suivis';
		// $_SESSION['s_ip']=$_SERVER['REMOTE_ADDR']; 
		// $qui =(empty($_SESSION['s_user'])) ? 'dbut transaction' : $_SESSION['s_user'];
		// $this->Suivis->insert(array(
			// 'suivis_id' => '',
			// 'suivis_qui' => (empty($_SESSION['s_nom_autorise'])) ? $qui : $_SESSION['s_nom_autorise'] ,
			// 'suivis_page' => trim($this->request->controller.'/'.$_SESSION['s_vue'],'/'),
			// 'suivis_date' => date('Y-m-d'),
			// 'suivis_heure' => date('H:i:s'),
			// 'suivis_ip' => $_SESSION['s_ip']
		// ));

	// }
}
?>