<?php
class Router{

	static $routes = array(); 
	static $prefixes = array(); 

	/**
	* Ajoute un prefix au Routing
	**/
	static function prefix($url,$prefix){
		self::$prefixes[$url] = $prefix; 
	}
	
	/**
	* Ajoute un prefix au Routing
	**/
	// static function langage($url,$lang){
		// //$params = explode('/',$url);
		// //var_dump($params);
	// //	self::$langages[$url] = $prefix; 
	// }
	/**
	* Permet de parser une url
	* @param $url Url  parser
	* @return tableau contenant les paramtres
	**/
	static function parse($url,$request){

		// pour debugger le droulemnt des appels de modules
		//echo "Session active est ".session_id()." - Module Router(parse)  at ".microtime(true).' sec'."<br/>"; 

		$url = trim($url,'/'); 
		if(empty($url)){
			$url = Router::$routes[0]['url']; 


		}else{
			$match = false; 
			foreach(Router::$routes as $v){
				if(!$match && preg_match($v['redirreg'],$url,$match)){
					$url = $v['origin'];
					foreach($match as $k=>$v){
						$url = str_replace(':'.$k.':',$v,$url); 
					} 
					$match = true; 
				}
			}
		}
		
// echo 'url : '; var_dump($url);
// echo 'routes : '; var_dump($routes);
	
		$params = explode('/',$url);
		if(in_array($params[0],array_keys(self::$prefixes))){
			$request->prefix = self::$prefixes[$params[0]];
			array_shift($params); 
		}
		$request->controller = $params[0];
		$request->action = isset($params[1]) ? $params[1] : 'index';
		foreach(self::$prefixes as $k=>$v){
			if(strpos($request->action,$v.'_') === 0){
				$request->prefix = $v;
				$request->action = str_replace($v.'_','',$request->action);  
			}
		}
		$request->params = array_slice($params,2);
		
// echo 'params : '; var_dump($params);	
// echo 'request : '; var_dump($request);

		return true; 
	}
	/**
	* Permet de connecter une url  une action particulire
	**/
	static function connect($redir,$url){
		$r = array();
		$r['params'] = array();
		$r['url'] = $url;  

		$r['originreg'] = preg_replace('/([a-z0-9]+):([^\/]+)/','${1}:(?P<${1}>${2})',$url);
		$r['originreg'] = str_replace('/*','(?P<args>/?.*)',$r['originreg']);
		$r['originreg'] = '/^'.str_replace('/','\/',$r['originreg']).'$/'; 
		// MODIF
		$r['origin'] = preg_replace('/([a-z0-9]+):([^\/]+)/',':${1}:',$url);
		$r['origin'] = str_replace('/*',':args:',$r['origin']); 

		$params = explode('/',$url);
		foreach($params as $k=>$v){
			if(strpos($v,':')){
				$p = explode(':',$v);
				$r['params'][$p[0]] = $p[1]; 
			}
		} 

		$r['redirreg'] = $redir;
		$r['redirreg'] = str_replace('/*','(?P<args>/?.*)',$r['redirreg']);
		foreach($r['params'] as $k=>$v){
			$r['redirreg'] = str_replace(":$k","(?P<$k>$v)",$r['redirreg']);
		}
		$r['redirreg'] = '/^'.str_replace('/','\/',$r['redirreg']).'$/';

		$r['redir'] = preg_replace('/:([a-z0-9]+)/',':${1}:',$redir);
		$r['redir'] = str_replace('/*',':args:',$r['redir']); 

		self::$routes[] = $r; 

	}

	/**
	* Permet de gnrer une url  partir d'une url originale
	* controller/action(/:param/:param/:param...)
	**/
	static function url($url = ''){

		trim($url,'/'); 
		foreach(self::$routes as $v){
			if(preg_match($v['originreg'],$url,$match)){
				$url = $v['redir']; 
				foreach($match as $k=>$w){
					$url = str_replace(":$k:",$w,$url); 
					//echo $url;
				}
			}
		}
		foreach(self::$prefixes as $k=>$v){
			if(strpos($url,$v) === 0){
				$url = str_replace($v,$k,$url); 
			}
		}
		
		return BASE_URL.'/'.$url; 

	}

	static function webroot($url){
		trim($url,'/');
		return BASE_URL.'/'.$url; 
	}

}